// FSMClient.cpp: CFSMClient NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "IB.h"
#include "FSMClient.h"
#include "FSMOutputDlg.h"
#include "SSMClient.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////
// O		:UINT CFSMClient::RecvThread( LPVOID pParam )
// @\		:MpXbh
// 		:*lpParam - gւ̃|C^
// ߂l	:Ȃ
//
UINT CFSMClient::RecvThread( LPVOID pParam )
{
//	cout << "Enter Thread." << endl;

	CFSMClient *pFSMClient = (CFSMClient*)pParam;

	int nRecv;						// MTCYێ
	string strMsg;					// Mf[^i[
	char szBuff[RECV_BUFFER_SIZE+1];		// Mpobt@
	
	TRACE("FSMMJn\n");
	while( 1 )
	{
		szBuff[0] = '\0';
		nRecv = pFSMClient->m_Socket.Recv( szBuff );

		if( nRecv == SOCKET_ERROR )
		{
			int ret = WSAGetLastError();
			pFSMClient->m_bActive = false;
			break;
		}

		strMsg.append( szBuff, nRecv );		

		int nIndex = strMsg.find("./\n",0);
		while(nIndex != -1)
		{
			string str = strMsg.substr(0,nIndex);
			pFSMClient->AnalyzeMsg(str.c_str());
			strMsg.erase(0,nIndex+3);
			nIndex = strMsg.find("./\n",0);
		}
	}

//	cout << "Exit Thread." << endl;
	pFSMClient->m_Socket.Close();
	WSACleanup();
//	ExitThread( pSRMClient->m_pThread->m_hThread );
	return 0;
}

CFSMClient::CFSMClient()
{
	m_pFSMDlg = NULL;
	m_bActive = false;
	m_pThread = NULL;
	WinSockInit();
}

CFSMClient::~CFSMClient()
{

}

//
// O		:void CFSMClient::WinSockInit()
// @\		:WinSock̏
// 		:Ȃ
// ߂l	:Ȃ
//
void CFSMClient::WinSockInit()
{
	// WinSock̏
	int		nResult;
	WORD	wRequireVersion;	// gpWinSock̃o[W
	WSADATA	lpWSAData;			// WinSocǩ

	// WinSock2gpWinSock̃o[WƂĐݒ
	wRequireVersion = MAKEWORD( 2, 0 );

	// WinSock̏sȂ
	nResult = WSAStartup( wRequireVersion, &lpWSAData );
	if( nResult != 0  )
	{
//		cerr << "WinSock̏Ɏs" << endl;
	}

	// WinSock̃o[Wv̂mF
	if( lpWSAData.wVersion != wRequireVersion )
	{
//		cerr << "vWinSock̃o[W擾ł܂ł" << endl;
	}
}

//
// O		:void CFSMClient::Run()
// @\		:MpXbh̊Jn
// 		:Ȃ
// ߂l	:Ȃ
//
void CFSMClient::Run()
{
	if( m_Socket.IsValid() )
	{
		m_pThread = AfxBeginThread(RecvThread,(LPVOID)this);
	}
}

//
// O		:void CFSMClient::Stop()
// @\		:MpXbh̒~
// 		:Ȃ
// ߂l	:Ȃ
//
void CFSMClient::Stop()
{
	SendMsg("CloseSocket./\n");
	// ڑҋ@p\Pbg
	m_Socket.Close();

	// XbhI܂őҋ@
	if(m_pThread!=NULL)
		WaitForSingleObject( m_pThread->m_hThread, 3000 );

	m_bActive = false;
//	cout << "Thread End." << endl;
}

//
// O		:BOOL CFSMClient::Initialize()
// @\		:CX^X̏
// 		:
// ߂l	: - TRUE s - FALSE
//
BOOL CFSMClient::Initialize()
{
	CWinApp *pApp = AfxGetApp();
	CString strIP = pApp->GetProfileString("ENGINE","IP",NULL);
	int nPort = pApp->GetProfileInt("FSM","Port",0);
//	CString strIP = "192.168.3.24";
//	int nPort = 10700;

	if( !m_Socket.IsValid() )
	{
		if(!m_Socket.Socket())
		{
			TRACE("\Pbg쐬s");
			return FALSE;
		}
	}
	if(!m_Socket.Connect(strIP,nPort))
	{
		TRACE("ڑvs");
		return FALSE;
	}
	m_bActive = true;
	return TRUE;
}


//
// O		:BOOL CFSMClient::SendMsg( LPCTSTR lpszMsg )
// @\		:msg𑗐M
// 		:&msg - M郁bZ[W
// ߂l	: - TRUE s - FALSE
//
BOOL CFSMClient::SendMsg( LPCTSTR lpszMsg )
{
	// bZ[W̃TCY𒲂ׂāASMł܂łЂsend
	string msg = lpszMsg;
	size_t nSize = msg.length();
	size_t nRet = 0;
	m_Socket.Lock();
	while( 1 )
	{
		if( nRet >= nSize )
			break;
		nRet += m_Socket.Send( &msg[nRet], nSize - nRet );
	}
	m_Socket.Unlock();
	return TRUE;
}

void CFSMClient::SetLipSync(LPCTSTR lpszText)
{
	SendMsg("prop Speak.stat = AutoOutput./\n");
	
	CString strCommand = "set LipSync.pho =";
	strCommand += lpszText;
	strCommand += "./\n";
	SendMsg(strCommand);
}

void CFSMClient::Speak()
{
	if(!m_pFSMDlg->m_strSpeakExpression.IsEmpty())
	{
		CString strMsg;
		strMsg.Format("set FaceExp = %s 1 100 %s./\n",
			m_pFSMDlg->m_strSpeakExpression,m_pFSMDlg->m_strSpeakDur);
		SendMsg(strMsg);
	}
	m_pFSMDlg->m_pSSMClient->Speak();
	SendMsg("set Speak = NOW./\n");
}

void CFSMClient::FaceExp(LPCTSTR lpszExpanded,LPCTSTR lpszDur)
{
	CString strMsg;
	strMsg.Format("set FaceExp = %s 1 100 %s./\n",lpszExpanded,lpszDur);
	SendMsg(strMsg);
}

void CFSMClient::FaceMot(LPCTSTR lpszAction,LPCTSTR lpszId)
{
	CString strMsg;
	strMsg.Format("set FaceMot = %s %s./\n",lpszAction,lpszId);
	SendMsg(strMsg);
}

void CFSMClient::Character(LPCTSTR lpszChr)
{
	CString strMsg;
	strMsg.Format("set Mask = %s./\n",lpszChr);
	SendMsg(strMsg);
}

void CFSMClient::Autonomous(LPCTSTR lpszAction)
{
	CString strMsg;
	if(strcmp(lpszAction,"STOP") == 0)
		strMsg = "set Autonomous = STOP./\n";
	else
		strMsg.Format("set Autonomous = %s 1./\n",lpszAction);

	SendMsg(strMsg);
}

void CFSMClient::StopSpeak()
{
	SendMsg("set Speak = STOP./\n");
}

void CFSMClient::AnalyzeMsg(LPCTSTR lpszMsg)
{
	CString strMsg;
	if(m_pFSMDlg)
	{
		strMsg.Format("FSM: %s\r\n",lpszMsg);
		m_pFSMDlg->WriteMsg(strMsg);
	}

	strMsg = lpszMsg;
	if(strMsg.Find("SPEAKING") != -1)
	{
		m_bSpeaking = true;
	}
	else if(strMsg.Find("READY") != -1)
	{
		Speak();
	}
	else if(strMsg.Find("IDLE") != -1)
	{
		if(m_bSpeaking)
		{
			m_bSpeaking = false;
			if(m_pFSMDlg)
				m_pFSMDlg->OnSpeakFinished();
		}
	}
}
